 
-- Copyright by Ufolec
-- www.landwirtschafts-simulator.pl
-- Wszelkie prawa zastrzeone

Vehicle.registerJointType("attachableFrontloader");

Z8602 = {};

function Z8602.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Z8602:load(xmlFile)
self.controlpathgearhud1 = Utils.getFilename("hud/gearhud1.png", self.baseDirectory);

self.hudGeargearhud1Width = 0.205;
    self.hudGeargearhud1Height = 0.255;
    self.hudGeargearhud1PoxX = 0.796;
    self.hudGeargearhud1PoxY = 0.666;
    self.hudGeargearhud1Overlay = Overlay:new("hudGeargearhud1", self.controlpathgearhud1, self.hudGeargearhud1PoxX, self.hudGeargearhud1PoxY, self.hudGeargearhud1Width, self.hudGeargearhud1Height);

self.controlpath4p = Utils.getFilename("hud/4p.png", self.baseDirectory);

self.hudGear4pWidth = 0.205;
    self.hudGear4pHeight = 0.255;
    self.hudGear4pPoxX = 0.796;
    self.hudGear4pPoxY = 0.666;
    self.hudGear4pOverlay = Overlay:new("hudGear4p", self.controlpath4p, self.hudGear4pPoxX, self.hudGear4pPoxY, self.hudGear4pWidth, self.hudGear4pHeight);

self.controlpath3p = Utils.getFilename("hud/3p.png", self.baseDirectory);

self.hudGear3pWidth = 0.205;
    self.hudGear3pHeight = 0.255;
    self.hudGear3pPoxX = 0.796;
    self.hudGear3pPoxY = 0.666;
    self.hudGear3pOverlay = Overlay:new("hudGear3p", self.controlpath3p, self.hudGear3pPoxX, self.hudGear3pPoxY, self.hudGear3pWidth, self.hudGear3pHeight);

self.controlpath2p = Utils.getFilename("hud/2p.png", self.baseDirectory);

self.hudGear2pWidth = 0.205;
    self.hudGear2pHeight = 0.255;
    self.hudGear2pPoxX = 0.796;
    self.hudGear2pPoxY = 0.666;
    self.hudGear2pOverlay = Overlay:new("hudGear2p", self.controlpath2p, self.hudGear2pPoxX, self.hudGear2pPoxY, self.hudGear2pWidth, self.hudGear2pHeight);

self.controlpath1p = Utils.getFilename("hud/1p.png", self.baseDirectory);

self.hudGear1pWidth = 0.205;
    self.hudGear1pHeight = 0.255;
    self.hudGear1pPoxX = 0.796;
    self.hudGear1pPoxY = 0.666;
    self.hudGear1pOverlay = Overlay:new("hudGear1p", self.controlpath1p, self.hudGear1pPoxX, self.hudGear1pPoxY, self.hudGear1pWidth, self.hudGear1pHeight);

self.controlpathI = Utils.getFilename("hud/I.png", self.baseDirectory);

self.hudGearIWidth = 0.205;
    self.hudGearIHeight = 0.255;
    self.hudGearIPoxX = 0.796;
    self.hudGearIPoxY = 0.666;
    self.hudGearIOverlay = Overlay:new("hudGearI", self.controlpathI, self.hudGearIPoxX, self.hudGearIPoxY, self.hudGearIWidth, self.hudGearIHeight);

self.controlpathII = Utils.getFilename("hud/II.png", self.baseDirectory);

self.hudGearIIWidth = 0.205;
    self.hudGearIIHeight = 0.255;
    self.hudGearIIPoxX = 0.796;
    self.hudGearIIPoxY = 0.666;
    self.hudGearIIOverlay = Overlay:new("hudGearII", self.controlpathII, self.hudGearIIPoxX, self.hudGearIIPoxY, self.hudGearIIWidth, self.hudGearIIHeight);

self.controlpathR = Utils.getFilename("hud/R.png", self.baseDirectory);

self.hudGearRWidth = 0.205;
    self.hudGearRHeight = 0.255;
    self.hudGearRPoxX = 0.796;
    self.hudGearRPoxY = 0.666;
    self.hudGearROverlay = Overlay:new("hudGearR", self.controlpathR, self.hudGearRPoxX, self.hudGearRPoxY, self.hudGearRWidth, self.hudGearRHeight);
	
	    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

	
	local rotationRpmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm#index"));
		if rotationRpmNode ~= nil then
        self.rotationRpm = {};
        self.rotationRpm.node = rotationRpmNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#minRot"));
        self.rotationRpm.minRot = {};
        self.rotationRpm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#maxRot"));
        self.rotationRpm.maxRot = {};
        self.rotationRpm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#rotTime"), 2)*1000;
        self.rotationRpm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#touchRotLimit"), 10));
    end;
	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.tahometr = {};
        self.tahometr.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.tahometr.minRot = {};
        self.tahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.tahometr.maxRot = {};
        self.tahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
    local drzwi_prawe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi_prawe#index"));
	if drzwi_prawe ~= nil then
		self.drzwi_prawe = drzwi_prawe;
	end;

	local drzwi_lewe = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drzwi_lewe#index"));
	if drzwi_lewe ~= nil then
		self.drzwi_lewe = drzwi_lewe;
	end;
	self.hudInfoPosX = 0.0154;
    self.hudInfoWidth = 1-0.4715;
    self.hudInfoPosY = 0.34;
    self.hudInfoHeight = 0.282;

	self.infoPanelInfoPath = Utils.getFilename("Skrypty/koloryHUD.png", self.baseDirectory);
	self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.infoPanelInfoPath, self.hudInfoPosX, self.hudInfoPosY, self.hudInfoWidth, self.hudInfoHeight);

	self.showhudInfo = false;
	self.kolorki = false;
	self.zaczepMode = 0;	
	local i = 0;
	self.dirtComponents = {};
	while true do
		local path = string.format("vehicle.dirt.dirtComponent(%d)", i);
		local component = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#index"));	
		if component == nil then
			break;
		end;
		table.insert(self.dirtComponents, component);
		i = i + 1;
	end;
    self.serwo1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.serwo1#index"));
	self.serwo2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.serwo2#index"));
    if self.serwo1 ~= nil then
        self.steeringSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.serwo1#rotationSpeed"), 0);
    end;
	if self.serwo2 ~= nil then
        self.steeringSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.serwo2#rotationSpeed"), 0);
    end;
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
	self.setHydraulicTime = 30;
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.przycisk1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.przycisk1#index"));
    self.przyciskklakson = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.przyciskklakson#index"));	
	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_lewy#index"));	
	self.kierunekActive = false;
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_prawy#index"));	
	self.kierunek2Active = false;
	turn1SoundFile = Utils.getFilename("Sounds/Z8602_kierunek1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	self.test = 800;	
	turn2SoundFile = Utils.getFilename("Sounds/Z8602_kierunek2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
    hornSoundFile = Utils.getFilename("Sounds/Z8602_klakson.wav", self.baseDirectory);
    self.hornSoundId = createSample("famerCarSound");
    loadSample(self.hornSoundId, hornSoundFile, false);
    self.hornPlaying = false;
	self.robocze = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.robocze#index"));
	self.roboczeActive = false; 
	self.numHeadLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.headLights#count"), 0);
    self.headLights = {};
    for i=1, self.numHeadLights do
        local headLightsNamei = string.format("vehicle.headLights.headLight" .. "%d", i);
        self.headLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, headLightsNamei .. "#index"));
        setVisibility(self.headLights[i], false);
    end;

	self.numFrontWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.frontWorkLights#count"), 0);
    self.frontWorkLights = {};
    for i=1, self.numFrontWorkLights do
        local frontWorkLightsNamei = string.format("vehicle.frontWorkLights.frontWorkLight" .. "%d", i);
        self.frontWorkLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, frontWorkLightsNamei .. "#index"));
        setVisibility(self.frontWorkLights[i], false);
    end;
	
	self.numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, self.numWorkLights do
        local workLightsNamei = string.format("vehicle.workLights.workLight" .. "%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLInt(xmlFile, workLightsNamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.kluczyk2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kluczyk2#index"));
	self.swiatla = 0;
	-- Sounds --
	
	
    FixingSoundFile = Utils.getFilename("Sounds/Z8602_naprawa.wav", self.baseDirectory);
    self.FixingSoundId = createSample("FixingSound");
    loadSample(self.FixingSoundId, FixingSoundFile, false);
    self.FixingPlaying = false;
	
    StairsSoundFile = Utils.getFilename("Sounds/Z8602_maska.wav", self.baseDirectory);
    self.StairsSoundId = createSample("StairsSound");
    loadSample(self.StairsSoundId, StairsSoundFile, false);
    self.StairsPlaying = false;
	
	
	-- Generating a random number --
	self.RandomNumber = math.random(2,30);	
	--print ("nombre:" , self.RandomNumber);

    self.maintenanceStairsInRange = false;
	self.Panels = false;
	self.servicePrice = 0;
	self.awaitingFixingAck = false;
	self.servicePrice = math.random(200,1500);
	self.currentLight = 0;	

	local rotationNodeEchellePanel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEchellePanel#index"));
    if rotationNodeEchellePanel ~= nil then
        self.rotationEchellePanel = {};
        self.rotationEchellePanel.node = rotationNodeEchellePanel;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#minRot"));
        self.rotationEchellePanel.minRot = {};
        self.rotationEchellePanel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEchellePanel#maxRot"));
        self.rotationEchellePanel.maxRot = {};
        self.rotationEchellePanel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEchellePanel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEchellePanel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEchellePanel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#rotTime"), 2)*1000;
        self.rotationEchellePanel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEchellePanel#touchRotLimit"), 10));
    end;


	local rotationPartNodeprzelacznikprawo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przelacznikprawo#index"));
    if rotationPartNodeprzelacznikprawo ~= nil then
        self.rotationPartprzelacznikprawo = {};
        self.rotationPartprzelacznikprawo.node = rotationPartNodeprzelacznikprawo;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartprzelacznikprawo#minRot"));
        self.rotationPartprzelacznikprawo.minRot = {};
        self.rotationPartprzelacznikprawo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelacznikprawo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelacznikprawo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przelacznikprawo#maxRot"));
        self.rotationPartprzelacznikprawo.maxRot = {};
        self.rotationPartprzelacznikprawo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelacznikprawo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelacznikprawo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartprzelacznikprawo.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelacznikprawo#rotTime"), 2)*1000;
        self.rotationPartprzelacznikprawo.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelacznikprawo#touchRotLimit"), 10));
    end;
	local rotationPartNodeprzelaczniklewo = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.przelaczniklewo#index"));
    if rotationPartNodeprzelaczniklewo ~= nil then
        self.rotationPartprzelaczniklewo = {};
        self.rotationPartprzelaczniklewo.node = rotationPartNodeprzelaczniklewo;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartprzelaczniklewo#minRot"));
        self.rotationPartprzelaczniklewo.minRot = {};
        self.rotationPartprzelaczniklewo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelaczniklewo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelaczniklewo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.przelaczniklewo#maxRot"));
        self.rotationPartprzelaczniklewo.maxRot = {};
        self.rotationPartprzelaczniklewo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartprzelaczniklewo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartprzelaczniklewo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartprzelaczniklewo.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelaczniklewo#rotTime"), 2)*1000;
        self.rotationPartprzelaczniklewo.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.przelaczniklewo#touchRotLimit"), 10));
    end;
	local shaftCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.drivingPowerShafts#count"), 0);
    self.drivingPowerShafts = {};
    for i=1, shaftCount do
		local shaft = {};
        local shaftName = string.format("vehicle.drivingPowerShafts.powerShaft%d", i);
		shaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, shaftName .. "#index"));		
		shaft.trans = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#translation"), 0);
		local x,y,z = getTranslation(getParent(shaft.node));
		shaft.orgTrans = {x,y,z};
		shaft.rot = Utils.degToRad(Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#rotation"), 0));	
		shaft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, shaftName .. "#speedFactor"), 2);
		table.insert(self.drivingPowerShafts, shaft);        
    end;
	self.lightSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightSwitch#index"));
	self.zaczep = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zaczep#index"));
	self.key = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.key#index"));
	self.engineRunTime = 0;	

	self.frontLightMode = 0;
	self.headLightActive = false;
	self.frontWorkLightActive = false;
	self.workLightActive = false;
	self.roboczeActive = false; 
	self.minAutoRotateSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheels#minAutoRotateBackSpeed"), self.autoRotateBackSpeed);
	self.maxAutoRotateSpeed = self.autoRotateBackSpeed;
	self.maxSpeed = getXMLFloat(xmlFile, "vehicle.wheels#maxSpeed");
 self.gearShifter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter#index"));
 self.gearShifter2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gearShifter2#index"));
end;

function Z8602:delete()
    if self.FixingSoundId ~= nil then
        stopSample(self.FixingSoundId);
    end;
    if self.StairsSoundId ~= nil then
        stopSample(self.StairsSoundId);
    end;	
    if self.hudInfoOverlay ~= nil then
		self.hudInfoOverlay:delete();
	end;
end;

function Z8602:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z8602:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_l then
		self.roboczeActive = not self.roboczeActive;
	end;
	if isDown and sym == Input.KEY_KP_1 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.kierunek2Active = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_KP_3 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.kierunekActive = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_KP_2 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	if self.flashLeft then
		if self.flashlightsLeft then

		end;
	end
	if self.flashRight then
		if self.flashlightsRight then

		end;
	end

end;

function Z8602:update(dt)	

	if self.isEntered then
			if InputBinding.hasEvent (InputBinding.hudgear) then
				self.hudgearactivate = not self.hudgearactivate;
			end;
	end;	

	local speed = self.lastSpeed*3600;
     if self.gearShifter2 ~= nil then
          if self.movingDirection < 0 then
               setRotation(self.gearShifter2, Utils.degToRad(-15), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActiveR = true;
				self.bcActiveI = false;
				self.bcActiveII = false;
          else     
          if speed >= 0 and speed < 0 then
               setRotation(self.gearShifter2, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActiveR = false;
				self.bcActiveI = false;
				self.bcActiveII = false;
		  elseif speed >= 0.5 and speed < 8 then
               setRotation(self.gearShifter2, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActiveR = false;
				self.bcActiveI = true;
				self.bcActiveII = false;
          elseif speed >= 8 then
               setRotation(self.gearShifter2, Utils.degToRad(15), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActiveR = false;
				self.bcActiveI = false;
				self.bcActiveII = true;
          end;
     end;
  end;

     if self.gearShifter ~= nil then
          if speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
          else     
--0--
          if speed >= -0.5 and speed < 0.5 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--1---
          elseif speed >= 0.5 and speed <2 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
		 elseif speed >= 8 and speed <9 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(-10));
				self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
--2---
          elseif speed >= 2 and speed < 4 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
			elseif speed >= 9 and speed < 11 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
--3---	

          elseif speed >= 4 and speed < 6 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
			elseif speed >= 11 and speed < 20 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
--4---
          elseif speed >= 6 and speed < 8 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
			elseif speed >= 20 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
				self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
--Back---
          elseif speed < -0.5 then
               setRotation(self.gearShifter, Utils.degToRad(0), Utils.degToRad(0), Utils.degToRad(0));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -1---
          elseif speed <= -0.5 and speed > -3 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(-10));
			   self.bcActive1p = true;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -2---
          elseif speed <= -3 and speed > -5 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
			   self.bcActive1p = false;
				self.bcActive2p = true;
				self.bcActive3p = false;
				self.bcActive4p = false;
-- -3---
          elseif speed <= -5 and speed > -10 then
               setRotation(self.gearShifter, Utils.degToRad(10), Utils.degToRad(0), Utils.degToRad(10));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = true;
				self.bcActive4p = false;
-- -4---
          elseif speed <= -10 then
               setRotation(self.gearShifter, Utils.degToRad(-10), Utils.degToRad(0), Utils.degToRad(10));
			   self.bcActive1p = false;
				self.bcActive2p = false;
				self.bcActive3p = false;
				self.bcActive4p = true;
          end;
     end;
  end;	
	
	if self:getIsActive() then
		local maxrpmneedle = 2500;
		if self.rotationRpm ~= nil and self.isMotorStarted == true then
		local x, y, z = getRotation(self.rotationRpm.node);
		local range = math.deg(self.rotationRpm.maxRot[2]) - math.deg(self.rotationRpm.minRot[2])
		local crpm = self.motor.lastMotorRpm*3
		local p = (crpm/maxrpmneedle) 
			y = self.rotationRpm.minRot[2] + math.rad((range*p)+(math.random(0,20)-10))
			setRotation(self.rotationRpm.node, x, y ,z);
		elseif self.rotationRpm ~= nil and self.isMotorStarted == false then
			setRotation(self.rotationRpm.node, 0, 0 ,0);
		end;
	end;

if self.isMotorStarted then
	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;
end;
	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
            if self.roboczeActive then
				setTranslation(self.przycisk1, 0, 0, Utils.degToRad(-2));
				else		
				setTranslation(self.przycisk1, 0, 0, Utils.degToRad(0));
			end;
	--manual fixing.
	local nearestDistance = 3.0; --max distance allowed
	local px, py, pz = getWorldTranslation(self.rotationEchellePanel.node); --self.Helice1 is one of the spereaders
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	if vx ~= nil and  vy ~= nil and vz ~= nil then
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.maintenanceStairsInRange = true; --farmer is in range
		else
			self.maintenanceStairsInRange = false; --farmer is not in range
		end;
	end;
	
	if self.maintenanceStairsInRange then
		if not self.Panels then
			g_currentMission:addExtraPrintText(string.format("%s: Otworz maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MAINTENANCELADDER)));	
		else
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.MAINTENANCELADDER)));
			g_currentMission:addExtraPrintText(string.format("%s: Napraw ciagnik", InputBinding.getKeyNamesOfDigitalAction(InputBinding.FIXCOMBINE)));
		end;
	end;
	
	
	if InputBinding.hasEvent(InputBinding.FIXCOMBINE) then
		if 	self.maintenanceStairsInRange and self.Panels then
			--if Player:getIsActiveForSound() then
			self.awaitingFixingAck = true;
			--end;
		end;
	end;
	
	
	if InputBinding.hasEvent(InputBinding.ACKNOWLEDGE) then
		if self.awaitingFixingAck then
			self.awaitingFixingAck = false;
			self.Breakdown = false;
			self.AuthorizeBreakdown = true;
			self.RandomNumber = self.RandomNumber + math.random(10,30);
			if not self.FixingPlaying then
				playSample(self.FixingSoundId, 1, 1, 0);
			end;
			--Fixing costs money!!!
            g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + self.servicePrice;
            g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + self.servicePrice;

            g_currentMission.missionStats.money = g_currentMission.missionStats.money - self.servicePrice;
			self.servicePrice = math.random(200,1500);
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.DECLINE) then
		if self.awaitingFixingAck then
			self.awaitingFixingAck = false;
		end;
	end;

	if self.awaitingFixingAck then
		setTextColor(1, 0, 0, 1.0);
		renderText(0.25, 0.5, 0.03, string.format("Czy chcesz naprawic ciagnik za: " ..self.servicePrice.. " Euro? T/N"));
	end;
	
	if InputBinding.hasEvent(InputBinding.MAINTENANCELADDER) then
		if 	self.maintenanceStairsInRange then
			self.Panels = not self.Panels;
			--if Player:getIsActiveForSound() then
				if not self.FixingPlaying then
					playSample(self.StairsSoundId, 1, 1, 0);
				end;
			--end;
		end;
	end;
	
	--renderText(0.5, 0.5, 0.020, string.format("%d ",self.RandomNumber));
	
	
	-- Manual fixing done
    	
		-- Movements --
	

	local doRotate = self.rotationEchellePanelMax or self.rotationEchellePanelMin 
	if self.rotationEchellePanel ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEchellePanel.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEchellePanel.maxRot, self.rotationEchellePanel.minRot, 3, self.rotationEchellePanel.rotTime, dt, not self.rotationEchellePanelMax);
        setRotation(self.rotationEchellePanel.node, unpack(newRot));
    end;

	--local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoomHolder ~= nil then
		local ax, ay, az = getWorldTranslation(self.safetyBoomHolderIndicator.node);
		local bx, by, bz = getWorldTranslation(self.rotationSafetyBoomHolder.node);

		local x, y, z = worldDirectionToLocal(getParent(self.rotationSafetyBoomHolder.node), bx-ax, by-ay, bz-az);
		setDirection(self.rotationSafetyBoomHolder.node, x, y, z, 0, 1, 0);
		
		--local x2,y2,z2 = getRotation(self.rotationSafetyBoomHolder.node);
		--setRotation(self.rotationSafetyBoomHolder.node,Utils.degToRad(22.5)+x2,0,0);
    end;

	local doRotate = self.rotationSafetyBoomMax or self.rotationSafetyBoomMin
	if self.rotationSafetyBoom ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationSafetyBoom.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationSafetyBoom.maxRot, self.rotationSafetyBoom.minRot, 3, self.rotationSafetyBoom.rotTime, dt, not self.rotationSafetyBoomMax);
        setRotation(self.rotationSafetyBoom.node, unpack(newRot));
    end;
	
	-- Panels Movements --
	
	if self.Panels then

		self.rotationEchellePanelMax = true;
		self.rotationEchellePanelMin = false;
		--self.AuthorizeBreakdown = false;

	else
		self.rotationEchellePanelMax = false;
		self.rotationEchellePanelMin = true;
	end;
		
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.drzwi_prawe) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end; 
		if InputBinding.hasEvent(InputBinding.drzwi_lewe) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end; 
		if InputBinding.hasEvent(InputBinding.szyba) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end; 
		if InputBinding.hasEvent(InputBinding.dach) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end; 
	end;	
	
	local nearestDistance = 2.6; 
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.drzwi_prawe); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz); 
	
	if distance < nearestDistance then
		self.player_wpoblizu = true; 
	else
		self.player_wpoblizu = false; 
	end;
	local nearestDistance = 2.6; 
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local rx, ry, rz = getWorldTranslation(self.drzwi_lewe); 
	local distance = Utils.vector3Length(rx-vx, ry-vy, rz-vz); 
	if distance < nearestDistance then
		self.player_wpoblizu = true; 
	else
		self.player_wpoblizu = false; 
	end;
    if self.player_wpoblizu then
		if InputBinding.hasEvent(InputBinding.ZACZEP) then
			self.zaczepMode = self.zaczepMode + 1;
			if self.zaczepMode > 3 then
				self.zaczepMode = 0;
			end;
	    end;
	end;
	if self.zaczepMode == 0  then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(0), 0);
		end;
	elseif self.zaczepMode == 1 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(3.6), 0);
		end;
	elseif self.zaczepMode == 2 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(7.2), 0);
		end;
	elseif self.zaczepMode == 3 then
		if self.zaczep ~= nil then
			setTranslation(self.zaczep, 0, Utils.degToRad(10.8), 0);
		end;
	end;
    if not self.isEntered and self.player_wpoblizu then
		if InputBinding.hasEvent(InputBinding.KOLOR) then
            self.kolorki = not self.kolorki;
		end;	
	end;
	if self.kolorki then
		self.showhudInfo = true;
	else
		self.showhudInfo = false;
	end;
	if self.player_wpoblizu then
		g_currentMission:addExtraPrintText(string.format("%s: Reguluj Zaczep", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ZACZEP)));
	    g_currentMission:addExtraPrintText(string.format("%s: Menu Malowania", InputBinding.getKeyNamesOfDigitalAction(InputBinding.KOLOR)));
	end;	
	if self.player_wpoblizu and not self.rotationMaxrightdoor == true then
		self.rotationMaxlewe = true;
	else
		self.rotationMaxlewe = false;
	end;




if self.rotationPartprzelaczniklewo ~= nil then
		local x, y, z = getRotation(self.rotationPartprzelaczniklewo.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartprzelaczniklewo.maxRot, self.rotationPartprzelaczniklewo.minRot, 3, self.rotationPartprzelaczniklewo.rotTime, dt, not self.rotationMaxprzelaczniklewo);
		setRotation(self.rotationPartprzelaczniklewo.node, unpack(newRot));
   end;
if self.rotationPartprzelacznikprawo ~= nil then
		local x, y, z = getRotation(self.rotationPartprzelacznikprawo.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartprzelacznikprawo.maxRot, self.rotationPartprzelacznikprawo.minRot, 3, self.rotationPartprzelacznikprawo.rotTime, dt, not self.rotationMaxprzelacznikprawo);
		setRotation(self.rotationPartprzelacznikprawo.node, unpack(newRot));
   end;


	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.LIGHTSCYCLE) then
			self.frontLightMode = self.frontLightMode + 1;
			if self.frontLightMode > 5 then
				self.frontLightMode = 0;
			end;
		end;
	end;
	if self.frontLightMode == 0  then
		self.headLightActive = false;
		self.workLightActive = false;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(0), 0);
		end;
	elseif self.frontLightMode == 1 or self.frontLightMode == 5 then
		self.headLightActive = true;
		self.workLightActive = false;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-20), 0);
		end;
	elseif self.frontLightMode == 2 or self.frontLightMode == 4 then
		self.headLightActive = true;
		self.workLightActive = true;
		self.frontWorkLightActive = false;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-40), 0);
		end;
	elseif self.frontLightMode == 3 then
		self.headLightActive = false;
		self.workLightActive = true;
		self.frontWorkLightActive = true;
		if self.lightSwitch ~= nil then
			setRotation(self.lightSwitch, 0, Utils.degToRad(-60), 0);
		end;
	end;
	
	for i=1, self.numHeadLights do
		setVisibility(self.headLights[i], self.headLightActive);
	end;
	
	for i=1, self.numFrontWorkLights do
		setVisibility(self.frontWorkLights[i], self.frontWorkLightActive);
	end;
	
	for i=1, self.numWorkLights do
		setVisibility(self.workLights[i], self.workLightActive);
	end;
	
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.kierunek2Active = true;
				self.kierunekActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.kierunek2Active = false;
				self.kierunekActive = false;
				playSample(self.turn2, 1, 0.7, 0);
				self.rotationMaxprzelacznikprawo = false;
			end;
		end;
		self.rotationMaxprzelacznikprawo = false;
		self.rotationMaxprzelaczniklewo = false;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.kierunek2Active = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.kierunek2Active = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
		self.rotationMaxprzelacznikprawo = true;
	else
		if not self.flashWarner then
			self.kierunek2Active = false;
			self.rotationMaxprzelacznikprawo = false;
		end;
	end;
	if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
			self.rotationMaxprzelaczniklewo = true;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
				self.rotationMaxprzelaczniklewo = false;
			end;
		end;
	setVisibility(self.kierunek, self.kierunekActive);
	setVisibility(self.kierunek2, self.kierunek2Active);
	setVisibility(self.robocze, self.roboczeActive);
    if self:getIsActiveForInput() and self:getIsActiveForSound() and InputBinding.isPressed(InputBinding.FARMER_CAR_HORN) then
        if not self.hornPlaying then
            playSample(self.hornSoundId, 0, 1, 0);
            self.hornPlaying = true;
        end;
    else
        if self.hornPlaying then
            stopSample(self.hornSoundId);
            self.hornPlaying = false;
        end;
    end;
            if InputBinding.isPressed(InputBinding.FARMER_CAR_HORN) then
				setTranslation(self.przyciskklakson, 0, Utils.degToRad(-0.5), 0);
				else		
				setTranslation(self.przyciskklakson, 0, Utils.degToRad(-0), 0);
			end;
    if self:getIsActive() then
        if self.serwo1 ~= nil then
            setRotation(self.serwo1, 0, 0, -self.rotatedTime*self.steeringSpeed);
        end;
		if self.serwo2 ~= nil then
            setRotation(self.serwo2, 0, 0, -self.rotatedTime*self.steeringSpeed);
        end;
    end;
end;
function Z8602:updateTick(dt)
	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(5, 1);
		else
			self:setAnimationTime(5, 0);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(6, 1);
		else
			self:setAnimationTime(6, 0);
		end;
	end;
	if self:getIsActive() then
	
		self.autoRotateBackSpeed = ((self.lastSpeed*3600 / self.maxSpeed) * (self.maxAutoRotateSpeed - self.minAutoRotateSpeed)) + self.minAutoRotateSpeed;
		
		for _, shaft in pairs(self.drivingPowerShafts) do
			local x,y,z = getRotation(self.wheels[1].driveNode);
			setRotation(shaft.node, 0 ,0, x*shaft.speedFactor);
			
			if shaft.trans ~= 0 then
				local newTrans = shaft.trans * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				local x,y,z = unpack(shaft.orgTrans);
				setTranslation(getParent(shaft.node), x + newTrans,y,z);
			end;
			if shaft.rot ~= 0 then
				newRot = shaft.rot * self.articulatedSteering.curRot/self.articulatedSteering.maxRot;
				setRotation(getParent(shaft.node), 0, newRot, 0);
			end;
			
		end;	
	end;
end;

function Z8602:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function Z8602:rotateNeedle(object, percent, min, max) 
    angle = min + (max - min) * percent;
    setRotation(object, self.PI, angle, self.PI_2);
end;

function Z8602:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];
	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;

end;

function Z8602:onEnter()
end;

function Z8602:draw()

	if self.hudgearactivate then
if self.isEntered then
 	 if self.hudGeargearhud1Overlay ~= nil then
    self.hudGeargearhud1Overlay:render();
end;
end;

if self.isEntered then
 	 if self.hudGear4pOverlay ~= nil then
  if self.bcActive4p then
    self.hudGear4pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear3pOverlay ~= nil then
  if self.bcActive3p then
    self.hudGear3pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear2pOverlay ~= nil then
  if self.bcActive2p then
    self.hudGear2pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGear1pOverlay ~= nil then
  if self.bcActive1p then
    self.hudGear1pOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearIOverlay ~= nil then
  if self.bcActiveI then
    self.hudGearIOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearIIOverlay ~= nil then
  if self.bcActiveII then
    self.hudGearIIOverlay:render();
  end;
end;
end;

if self.isEntered then
 	 if self.hudGearROverlay ~= nil then
  if self.bcActiveR then
    self.hudGearROverlay:render();
  end;
end;
end;
end;	
end;

function Z8602:attachImplement(implement)
end;

function Z8602:detachImplement(implementIndex)
end;

function Z8602:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
	
function Z8602:onLeave()
end;